require( "scripts/style.lua" );

HeaderFont = {
  standardFont,
  40,
  BlackColor
};


GameModeFont = {
  standardFont,
  30,
  BlackColor
};

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

ConnectingToServerFont = {
	standardFont,
	18,
	BlackColor
};

LabelHeaderFont = {
  standardFont,
  30,
  BlackColor
};

TableHeaderFont = {
  standardFont,
  30,
  BurgundyColor
};

ScoreInfoFont = {
  standardFont,
  20,
  BlackColor
};


ScoreFont = {
  standardFont,
  20,
  BurgundyColor
};

-- Need a version without italics (doesn't right justify well)
ScoreNumberFont = {
  nonItalicFont,
  17,
  BurgundyColor
};

RankFont = {
  standardFont,
  26,
  BurgundyColor
};

ChangeViewFont = {
  standardFont,
  24,
  BlackColor
};

SmallBlackFont = {
  standardFont,
  16,
  BlackColor
};

SmallPurpleFont = {
  standardFont,
  16,
  PurpleColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

BlueLeftButtonGraphics = {
	"buttons/bluearrowleft_up.png",
	"buttons/bluearrowleft_down.png",
	"buttons/bluearrowleft_over.png"
};

BlueRightButtonGraphics = {
	"buttons/bluearrowright_up.png",
	"buttons/bluearrowright_down.png",
	"buttons/bluearrowright_over.png"
};

UpButtonGraphics = {
	"buttons/arrowup_up.png",
	"buttons/arrowup_down.png",
	"buttons/arrowup_over.png"
};

DownButtonGraphics = {
	"buttons/arrowdown_up.png",
	"buttons/arrowdown_down.png",
	"buttons/arrowdown_over.png"
};

ChangeViewButtonGraphics = {
	"buttons/highscores_btn_purp_idle.png",
	"buttons/highscores_btn_purp_down.png",
	"buttons/highscores_btn_purp_hl.png"
};


kScoreRowSpace = 25;
kRowY = 62;
kNumberX = 75;
kNameX = 110;
kScoreX = 290;
kP1X = kNumberX + 14;
kPlayfirstIconYOffset = 2;
kMaxNameWidth = 220;
kMaxNameHeight = 20;
kLocalNumbersX = 13;

MakeDialog
{
	
	Bitmap
	{ 
		image="hiscore/hiscores_BG",	
		name="hiscorescreen",
		
		HiscoreWindow
		{
			x=0,y=0,h=kMax,w=kMax,
			
			Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=7,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "highscoreheader"
			};
			
			Text
			{
				font = GameModeFont,
				name = "gamemode",
				x=405,y=100,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "GAMEMODE"
			};
			
			Bitmap
			{
				x = 70,
				y = 140,
				w=302,
				h=kMax,
				image="hiscore/global-hs-bb_large.png",	
				name="leftpanel",
				
				Text
				{
					font = TableHeaderFont,
					name = "local",
					x=120,y=0,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "localhighscores"
				};
				
				Text
				{
					font = TableHeaderFont,
					name = "global",
					x=120,y=0,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};
				
				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=120,y=0,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "topplayers"
				};
				
				Text
				{
					font = ScoreFont,
					name = "1",
					x=kLocalNumbersX,y=kRowY,w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "1."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_1",
					x=kP1X,y=kRowY + kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name1",
					x=kNameX,y=kRowY,w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score1",
					x=kLocalNumbersX,y=kRowY,w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "2",
					x=kLocalNumbersX,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "2."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_2",
					x=kP1X,y=kRowY+(1*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				
				Text
				{
					font = ScoreFont,
					name = "name2",
					x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score2",
					x=kLocalNumbersX,y=kRowY+(1*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "3",
					x=kLocalNumbersX,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "3."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_3",
					x=kP1X,y=kRowY+(2*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name3",
					x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score3",
					x=kLocalNumbersX,y=kRowY+(2*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "4",
					x=kLocalNumbersX,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "4."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_4",
					x=kP1X,y=kRowY+(3*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name4",
					x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score4",
					x=kLocalNumbersX,y=kRowY+(3*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "5",
					x=kLocalNumbersX,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "5."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_5",
					x=kP1X,y=kRowY+(4*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name5",
					x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score5",
					x=kLocalNumbersX,y=kRowY+(4*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "6",
					x=kLocalNumbersX,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "6."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_6",
					x=kP1X,y=kRowY+(5*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name6",
					x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score6",
					x=kLocalNumbersX,y=kRowY+(5*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "7",
					x=kLocalNumbersX,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "7."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_7",
					x=kP1X,y=kRowY+(6*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name7",
					x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score7",
					x=kLocalNumbersX,y=kRowY+(6*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "8",
					x=kLocalNumbersX,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "8."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_8",
					x=kP1X,y=kRowY+(7*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name8",
					x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score8",
					x=kLocalNumbersX,y=kRowY+(7*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "9",
					x=kLocalNumbersX,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "9."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_9",
					x=kP1X,y=kRowY+(8*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name9",
					x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score9",
					x=kLocalNumbersX,y=kRowY+(8*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "10",
					x=kLocalNumbersX,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "10."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_10",
					x=kP1X,y=kRowY+(9*kScoreRowSpace)+kPlayfirstIconYOffset
				};
				
				Text
				{
					font = ScoreFont,
					name = "name10",
					x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kMaxNameWidth,h=kMaxNameHeight,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreNumberFont,
					name = "score10",
					x=kLocalNumbersX,y=kRowY+(9*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
			};
			
			Bitmap
			{
				x = 470,
				y = 150,
				image="hiscore/global-hs-bb_small.png",	
				name="rightpanelsmall",
				
				Text
				{
					font = ScoreInfoFont,
					name = "yourrankglobalinfo",
					x=10,y=55,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscoreinfo"
				};
				
				Text
				{
					font = RankFont,
					name = "yourrank",
					x=10,y=15,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "yourrank"
				};
				
				Text
				{
					font = RankFont,
					name = "congratulations",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "congratshighscore"
				};
				
				Text
				{
					font = RankFont,
					name = "dnq",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scorednq"
				};
			},
			
			
			Bitmap
			{
				x = 470,
				y = 150,
				image="hiscore/local-hs-bb.png",	
				name="rightpanel",
				
				Text
				{
					font = TableHeaderFont,
					name = "globalinfoheader",
					x=kLocalNumbersX,y=15,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};
				
				Text
				{
					font = ScoreInfoFont,
					name = "info",
					x=10,y=55,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscoreinfo"
				};
					
				Button
				{
					factory = "fadebutton",
					x=80,
					y=130,
					font = StandardButtonFont,
					graphics = StandardButtonGraphics,
					name="moreinfo",
					label="moreinfo",
					type = kPush,
					command =
						function()
							DoModal("scripts/hiscoreinfo.lua");
						end
					
				};
				
				Text
				{
					font = ScoreInfoFont,
					name = "eligible",
					x=0,y=200,w=kMax-10,h=60,
					flags = kHAlignCenter + kVAlignTop,
					label = "eligible_no_astrix"
				};
				
				Text
				{
					font = AsteriskFont,
					name = "highscoresasterisk",
					x=10,y=307,w=kMax-10,h=60,
					flags = kHAlignCenter + kVAlignTop,
					label = "highscoresasterisk"
				};
					
				Button
				{
					factory = "fadebutton",
					x=80,
					y=240,
					font = StandardButtonFont,
					graphics = StandardButtonGraphics,
					name="submit",
					label="submit",
					type = kPush
				};
			};
			
			
			
			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=475,y=400,w=258,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "connectingtoserver"
			};
			
			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=475,y=400,w=258,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "Server error"
			};
			
			
			
			Text
			{
				font = ScoreFont,
				name = "category",
				x=168,y=170,w=201,h=40,
				flags = kHAlignCenter + kVAlignTop,
				label = "Category Name"
			};
			
			Button
			{
				factory = "fadebutton",
				font = StandardButtonFont,
				graphics = LeftButtonGraphics,
				name="gamemodeleft",
				label="",
				type = kPush,
				x=450,
				y=92,
				scale = 0.8
			};
			
			Button
			{
				factory = "fadebutton",
				font = StandardButtonFont,
				graphics = RightButtonGraphics,
				name="gamemoderight",
				label="",
				type = kPush,
				x=690,
				y=92,
				scale = 0.8
			};
			
			Button
			{
				factory = "fadebutton",
				font = StandardButtonFont,
				graphics = BlueLeftButtonGraphics,
				name="categoryleft",
				label="",
				type = kPush,
				x=167,
				y=165,
				scale = 0.8
			};
			
			Button
			{
				factory = "fadebutton",
				font = StandardButtonFont,
				graphics = BlueRightButtonGraphics,
				name="categoryright",
				label="",
				type = kPush,
				x=337,
				y=165,
				scale = 0.8
			};
			
			
			
			Button
			{
				factory = "fadebutton",
				font = StandardButtonFont,
				graphics = UpButtonGraphics,
				name="scrollup",
				label="",
				type = kPush,
				x=420,
				y=225,
				scale = 0.8
			};
			
			Button
			{
				factory = "fadebutton",
				font = StandardButtonFont,
				graphics = DownButtonGraphics,
				name="scrolldown",
				label="",
				type = kPush,
				x=420,
				y=430,
				scale = 0.8
			};
			
			
			
			
			Button
			{
				factory = "fadebutton",
				x=188,
				y=501,
				font = ChangeViewFont,
				graphics = ChangeViewButtonGraphics,
				name="view",
				label="viewglobal",
				type = kPush
			};
			
			Button
			{
				factory = "fadebutton",
				x=188,
				y=501,
				font = ChangeViewFont,
				graphics = ChangeViewButtonGraphics,
				name="viewlocal",
				label="viewlocal",
				type = kPush
			};
			
			Button
			{
				factory = "fadebutton",
				x=kCenter,
				y=553,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="back",
				type = kPush,
				flags = kHAlignCenter + kVAlignCenter,
				label="back",
				command = 
					function()
						PopModal();
					end
			};
			
			SetStyle(DefaultStyle);
			Button
			{
				name="privacypolicy",
				x=0,y=0,w=0,h=0,
				command = 
				    function()
					  LaunchPrivacyPolicy();
				    end
			};
		};
	}
}